#ifndef _KCOMPAT_H_
#define _KCOMPAT_H_

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#else
#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#endif

#ifdef __has_attribute
#if __has_attribute(__fallthrough__)
# define fallthrough __attribute__((__fallthrough__))
#else
# define fallthrough do {} while (0)  /* fallthrough */
#endif /* __has_attribute(fallthrough) */
#else
# define fallthrough do {} while (0)  /* fallthrough */
#endif /* __has_attribute */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(5, 8, 0))
#else /* > 5.8.0 */
#define probe_kernel_read copy_from_kernel_nofault
#endif /* < 5.8.0 */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(6, 4, 0))
#define HAVE_CLASS_CREATE_EXTRE_PARAM
#endif /* < 6.4.0 */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(6, 5, 0))
#define HAVE_NO_MEM_DEVNODE
#endif /* < 6.5.0 */

#endif /* _KCOMPAT_H_ */
